<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */

?>
<!-- ======= Footer ======= -->
  <footer id="footer">
    <div class="ftrtop_sec">
      <div class="container">
        <div class="row">
          <div class="col-md-6 col-lg-3">
            <div class="ftrbxes ftr_about text-center">
              <img src="<?php echo get_template_directory_uri(); ?>/assets/img/ftr-logo.webp" alt="">
              <p class="my-5">UK Glaze Manufacturer, Glass Splashbacks, Mirror 
Glass, Glass Balustrade Suppliers in Essex, Serving London, Kent, Surrey, Cambridgeshire, Northamptonshire and 
the West Midlands and the UK.</p>
              <div class="bsilogo">
                <img src="<?php echo get_template_directory_uri(); ?>/assets/img/ce-logo.webp" alt="" class="img-fluid">
              </div>
            </div>
          </div>
          <div class="col-md-6 col-lg-3 mt-5 mt-md-0">
            <div class="ftrbxes ftr_contactInfo">
              <h3>Contact Details</h3>
              <ul class="ftrAdd_list">
                <li>
                  <i class="fa-solid fa-phone"></i>
                  <a href="tel:08009949534">0800 994 9534</a>
                </li>
                <li>
                  <i class="fas fa-map-marker-alt"></i>
                  <span>15 Leeming Rd, Borehamwood WD6 4EB</span>
                </li>
                <li>
                  <i class="fa-solid fa-envelope"></i>
                  <a href="mailto:info@empireofglass.co.uk">info@empireofglass.co.uk</a>
                </li>
              </ul>
            </div>
          </div>
          <div class="col-md-6 col-lg-3 mt-5 mt-lg-0">
            <div class="ftrbxes ftr_useFulLinks">
              <h3>Useful Links</h3>
              <ul class="nav">
                <li><a class="nav-link" href="#">Home</a></li>
                <li><a class="nav-link" href="#">About Us</a></li>
                <li><a class="nav-link" href="#">Our Products</a></li>
                <li><a class="nav-link" href="#">Our Gallery </a></li>
                <li><a class="nav-link" href="#">Latest Articles</a></li>
                <li><a class="nav-link" href="#">Contact Us</a></li>
              </ul>
            </div>
          </div>
          <div class="col-md-6 col-lg-3 mt-5 mt-lg-0">
            <div class="ftrbxes ftr_useFulLinks">
              <h3>Our Product Range</h3>
              <ul class="nav">
                <li><a class="nav-link" href="#">Conservatory Glass</a></li>
                <li><a class="nav-link" href="#">Glass Balustrade</a></li>
                <li><a class="nav-link" href="#">Glass Doors </a></li>
                <li><a class="nav-link" href="#">Glass Partitions</a></li>
                <li><a class="nav-link" href="#">Juliet Balcony</a></li>
                <li><a class="nav-link" href="#">View All</a></li>
              </ul>
            </div>
          </div>
          
        </div>
      </div>
    </div>
    <div class="ftrcopyRight text-center">
      <div class="container">
        <div class="row d-md-flex align-items-center">
          <div class="col-md-3 col-lg-5 order-md-1">
            <div class="ftr-payment">
              <a href="#"><img src="<?php echo get_template_directory_uri(); ?>/assets/img/payment-icons.webp" alt="" class="img-fluid"></a>
            </div>
          </div>
          <div class="col-md-9 col-lg-7">
            <div class="ftr-copyRt">
              <ul class="nav">
                <li><a class="nav-link" href="#">Privacy Policy </a></li>
                <li><a class="nav-link" href="#">Terms & Conditions</a></li>
                <li><a class="nav-link" href="#">Shipping and Returns</a></li>
                <li><a class="nav-link" href="#">Quality and Ethical Responsibilities</a></li>
              </ul>
              <p class="mb-0">© Copyright 2024 - <a href="#" class="ftrcprLink">Empire of Glass LTD</a></p>
            </div>
          </div>
        </div>
      </div>
    </div>

  </footer><!-- End Footer -->

  <!-- <div id="preloader"></div>
    <a href="#" class="back-to-top d-flex align-items-center justify-content-center">
      <i class="bi bi-arrow-up-short"></i>
    </a> -->

  <!-- Vendor JS Files -->
  <script src="<?php echo get_template_directory_uri(); ?>/assets/vendor/jquery/jquery.min.js"></script>
  <script src="<?php echo get_template_directory_uri(); ?>/assets/vendor/purecounter/purecounter_vanilla.js"></script>
  <script src="<?php echo get_template_directory_uri(); ?>/assets/vendor/aos/aos.js"></script>
  <script src="<?php echo get_template_directory_uri(); ?>/assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="<?php echo get_template_directory_uri(); ?>/assets/vendor/glightbox/js/glightbox.min.js"></script>
  <script src="<?php echo get_template_directory_uri(); ?>/assets/vendor/swiper/swiper-bundle.min.js"></script>
  <script src="<?php echo get_template_directory_uri(); ?>/assets/vendor/php-email-form/validate.js"></script>
  <script src="<?php echo get_template_directory_uri(); ?>/assets/popup-gallery/jquery.magnific-popup.js"></script>

  <!-- Template Main JS File -->
  <script src="<?php echo get_template_directory_uri(); ?>/assets/js/owl.carousel.min.js"></script>
  <script src="<?php echo get_template_directory_uri(); ?>/assets/js/scrollbar.js"></script>
  <script src="<?php echo get_template_directory_uri(); ?>/assets/js/mobileMenu.js"></script>
  <script src="<?php echo get_template_directory_uri(); ?>/assets/js/main.js"></script>

  <script>
    jQuery(document).ready(function ($) {
      /* Image Popup*/
      $('#see_our_gallery .row').magnificPopup({
        delegate: 'a',
        type: 'image',
        tLoading: 'Loading image #%curr%...',
        mainClass: 'mfp-img-mobile',
        gallery: {
          enabled: true,
          navigateByImgClick: true,
          preload: [0, 1] // Will preload 0 - before current, and 1 after the current image
        },

      });

      jQuery('.sidebarInfo nav').mobilemenu();

      $(".dismiss, .overlay").on("click", function () {
        $(".sidebar").removeClass("active");
        $(".overlay").removeClass("active");
      });

      $(".open-menu").on("click", function (e) {
        e.preventDefault();
        $(".sidebar").addClass("active");
        $(".overlay").addClass("active");
        // close opened sub-menus
        $(".collapse.show").toggleClass("show");
        $("a[aria-expanded=true]").attr("aria-expanded", "false");
      });

      $('.popup-youtube, .popup-vimeo').magnificPopup({
        type: 'iframe',
        mainClass: 'mfp-fade',
        removalDelay: 160,
        preloader: false,
        fixedContentPos: true
      });

      const items = document.querySelectorAll('.accordion button');
      function toggleAccordion() {
        const itemToggle = this.getAttribute('aria-expanded');
        for (i = 0; i < items.length; i++) {
          items[i].setAttribute('aria-expanded', 'false');
        }
        if (itemToggle == 'false') {
          this.setAttribute('aria-expanded', 'true');
        }
      }
      items.forEach((item) => item.addEventListener('click', toggleAccordion));

      $('.sidebar').mCustomScrollbar({
        theme: "minimal-dark"
      });

    });
  </script>
  <script>
    jQuery(document).ready(function ($) {
      $('.hero-banner').owlCarousel({
        items: 1,
        loop: false,
        nav: false,
        dots: true,
        margin: 0,
        navText: ["<i class='fa-solid fa-angle-left'></i>", "<i class='fa-solid fa-angle-right'></i>"],
        dotsContainer: '#custom-owl-dots',
      });
      $('.owl-dot').click(function () {
        owl.trigger('to.owl.carousel', [$(this).index(), 300]);
      });
      var owl = $(".hero-banner, #customer-testmls");
      owl.owlCarousel();
      $(".owl-next").click(function () {
        owl.trigger("next.owl.carousel");
      });
      $(".owl-prev").click(function () {
        owl.trigger("prev.owl.carousel");
      });
      $(".owl-prev").addClass("disabled");
      $(owl).on("translated.owl.carousel", function (event) {
        if ($(".owl-prev").hasClass("disabled")) {
          $(".owl-prev").addClass("disabled");
        } else {
          $(".owl-prev").removeClass("disabled");
        }
        if ($(".owl-next").hasClass("disabled")) {
          $(".owl-next").addClass("disabled");
        } else {
          $(".owl-next").removeClass("disabled");
        }
      });
    });
  </script>
  <script>
    $('#customer-testmls').owlCarousel({
      loop:true,
      margin:20,
      dots:false,
      nav:true,
      navText: [
        '<i class="fa fa-angle-left" aria-hidden="true"></i>',
        '<i class="fa fa-angle-right" aria-hidden="true"></i>'
    ],
      responsive:{
          0:{
              items:1
          },
          600:{
              items:1
          },
          992:{
              items:2,
              margin:100,
          }
      }
  })
  </script>

<?php wp_footer(); ?>

</body>
</html>
