<?php
/**
 * The header.
 *
 * This is the template that displays all of the <head> section and everything up until main.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */

?>
<!doctype html>
<html <?php language_attributes(); ?> <?php twentytwentyone_the_html_classes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<meta name="viewport" content="width=device-width, initial-scale=1.0" />
	<link href="<?php echo get_template_directory_uri(); ?>/assets/img/favicon.webp" rel="icon">
  <link href="<?php echo get_template_directory_uri(); ?>/assets/img/apple-touch-icon.webp" rel="apple-touch-icon">

  <!-- Google Fonts -->
  <link
    href="https://fonts.googleapis.com/css2?family=DM+Sans:ital,opsz,wght@0,9..40,100..1000;1,9..40,100..1000&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
    rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="<?php echo get_template_directory_uri(); ?>/assets/vendor/fontawesome-free/css/all.min.css" rel="stylesheet">
  <link href="<?php echo get_template_directory_uri(); ?>/assets/vendor/animate.css/animate.min.css" rel="stylesheet">
  <link href="<?php echo get_template_directory_uri(); ?>/assets/vendor/aos/aos.css" rel="stylesheet">
  <link href="<?php echo get_template_directory_uri(); ?>/assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="<?php echo get_template_directory_uri(); ?>/assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="<?php echo get_template_directory_uri(); ?>/assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="<?php echo get_template_directory_uri(); ?>/assets/vendor/glightbox/css/glightbox.min.css" rel="stylesheet">
  <link href="<?php echo get_template_directory_uri(); ?>/assets/vendor/swiper/swiper-bundle.min.css" rel="stylesheet">
  <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/owl.carousel.min.css">
  <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/owl.theme.default.css">
  <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/scrollbar.css" />
  <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/popup-gallery/magnific-popup.css" />
  <link href="<?php echo get_template_directory_uri(); ?>/assets/css/mobile-menu.css" rel="stylesheet">
  <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/submenu.css" type="text/css">
  <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/slideInUp-nav.css" type="text/css">
  <!-- Template Main CSS File -->
  <link href="<?php echo get_template_directory_uri(); ?>/assets/css/navbar.css" rel="stylesheet">
  <link href="<?php echo get_template_directory_uri(); ?>/assets/css/style.css" rel="stylesheet">
  <link href="<?php echo get_template_directory_uri(); ?>/assets/css/responsive.css" rel="stylesheet">
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<!-- Wrapper -->
  <div class="wrapper">
    <!-- Sidebar -->
    <nav class="sidebar d-xxl-none">

      <!-- close sidebar menu -->
      <div class="dismiss">
        <i class="fa-solid fa-xmark"></i>
      </div>

      <div class="logo">
        <a class="navbar-brand mx-auto" href="#">
          <img src="<?php echo get_template_directory_uri(); ?>/assets/img/logo.webp" alt="" class="img-fluid">
        </a>
      </div>
      <div class="sidebar-mblsec">
          <div class="social-style1 d-flex">
              <span class="social-title">Follow Us On :</span>
              <div class="social-icon">
                <a href="#"><i class="fab fa-facebook-f"></i></a>
                <a href="#"><i class="fab fa-instagram"></i></a>
                <a href="#"><i class="fa-brands fa-linkedin-in"></i></a>
              </div>
            </div>
          <div class="secbtn rqustQuote">
            <a href="#" class="btn btn-info">Request a Quote <img src="<?php echo get_template_directory_uri(); ?>/assets/img/arrow-rt.webp" alt=""
                class="ml-2"></a>
          </div>
        </div>
      <div class="sidebarInfo">
        <nav id="mobile-menu">
          <ul>
            <li><a class="nav-link" href="<?php echo home_url(); ?>">Home</a></li>
            <li><a class="nav-link" href="about-us.html">About</a></li>
            <li><a href="#">Our Products</a>
              <ul>
                <li>
                  <div class="mega_menu sub_menu">
                    <div class="mega_menu_item">
                      <a href="#">xyxx</a>
                      <a href="#">xyxx</a>
                      <a href="#">xyxx</a>
                      <a href="#">xyxx</a>
                      <a href="#">xyxx</a>
                      <a href="#">xyxx</a>
                    </div>
                    <div class="mega_menu_item">
                      <a href="#">xyxx</a>
                      <a href="#">xyxx</a>
                      <a href="#">xyxx</a>
                      <a href="#">xyxx</a>
                      <a href="#">xyxx</a>
                      <a href="#">xyxx</a>
                    </div>
                    <div class="mega_menu_item">
                      <a href="#">xyxx</a>
                      <a href="#">xyxx</a>
                      <a href="#">xyxx</a>
                      <a href="#">xyxx</a>
                      <a href="#">xyxx</a>
                      <a href="#">xyxx</a>
                    </div>
                  </div>
                </li>
              </ul>
            </li>
            <li><a class="nav-link" href="#">Our Gallery</a></li>
            <li><a class="nav-link" href="#">Latest Articles</a></li>
            <li><a class="nav-link" href="#">Contact Us</a></li>
          </ul>
        </nav>
        
      </div>
    </nav>
    <!-- End sidebar -->

    <!-- Dark overlay -->
    <div class="overlay"></div>
    <!-- ======= Header ======= -->
    <header id="header" class="">
      <div class="container-fluid px-lg-5">
        <div class="topHeader d-flex align-items-center">
          <nav class="main-nav d-none d-xxl-block">
            <ul class="nav">
              <li><a class="nav-link active" href="<?php echo home_url(); ?>">Home</a></li>
              <li><a class="nav-link" href="#">About Us</a></li>
              <li class="mega-menu">
                <a class="nav-link" href="#">
                  Our Products
                  <span role="presentation" class="dropdown-menu-toggle"><span class="gp-icon icon-arrow"><svg
                        viewBox="0 0 330 512" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="1em"
                        height="1em">
                        <path
                          d="M305.913 197.085c0 2.266-1.133 4.815-2.833 6.514L171.087 335.593c-1.7 1.7-4.249 2.832-6.515 2.832s-4.815-1.133-6.515-2.832L26.064 203.599c-1.7-1.7-2.832-4.248-2.832-6.514s1.132-4.816 2.832-6.515l14.162-14.163c1.7-1.699 3.966-2.832 6.515-2.832 2.266 0 4.815 1.133 6.515 2.832l111.316 111.317 111.316-111.317c1.7-1.699 4.249-2.832 6.515-2.832s4.815 1.133 6.515 2.832l14.162 14.163c1.7 1.7 2.833 4.249 2.833 6.515z">
                        </path>
                      </svg></span></span>
                </a>
                <ul class="sub-menu">
                  <li>
                    <a class="nav-link" href="#">Glass Products</a>
                    <ul class="sub-menu">
                      <li><a href="#">xyz</a></li>
                      <li><a href="#">xyz</a></li>
                      <li><a href="#">xyz</a></li>
                      <li><a href="#">xyz</a></li>
                    </ul>
                  </li>
                  <li>
                    <a class="nav-link" href="#">Glass Products</a>
                    <ul class="sub-menu">
                      <li><a href="#">xyz</a></li>
                      <li><a href="#">xyz</a></li>
                      <li><a href="#">xyz</a></li>
                      <li><a href="#">xyz</a></li>
                    </ul>
                  </li>
                  <li>
                    <a class="nav-link" href="#">Glass Products</a>
                    <ul class="sub-menu">
                      <li><a href="#">xyz</a></li>
                      <li><a href="#">xyz</a></li>
                      <li><a href="#">xyz</a></li>
                      <li><a href="#">xyz</a></li>
                    </ul>
                  </li>
                </ul>
              </li>
              <li><a class="nav-link" href="#">Our Gallery</a></li>
              <li><a class="nav-link" href="#">Latest Articles</a></li>
              <li><a class="nav-link" href="#">Contact Us</a></li>
            </ul>
          </nav>
          <div class="btn-btp-cutm">
            <!-- open sidebar menu -->
            <a class="btn btn-primary btn-customized open-menu d-none d-xl-block ms-lg-0 d-xxl-none" href="#" role="button">
              <i class="fas fa-align-left"></i>
            </a>
            <a href="<?php echo home_url(); ?>" class="logo"><img src="<?php echo get_template_directory_uri(); ?>/assets/img/logo.webp" alt=""></a>
          </div>
          <div class="tph-sec d-flex">
            <div class="top-hdr-rtsec">
            <div class="social-style1 d-none d-md-flex">
              <span class="social-title">Follow Us On :</span>
              <div class="social-icon">
                <a href="#"><i class="fab fa-facebook-f"></i></a>
                <a href="#"><i class="fab fa-instagram"></i></a>
                <a href="#"><i class="fa-brands fa-linkedin-in"></i></a>
              </div>
            </div>
            <div class="top-cart">
              <div class="top-cart-icon-box">
                <div class="topcar-icon">
                  <img src="<?php echo get_template_directory_uri(); ?>/assets/img/card-icon.webp" alt="" class="img-fluid">
                </div>
              </div>
              <div class="tpcart">
                Cart
                <span>0</span>
              </div>
            </div>
            <div class="secbtn rqustQuote d-none d-lg-block">
              <a href="#" class="btn btn-info">Request a Quote <img src="<?php echo get_template_directory_uri(); ?>/assets/img/arrow-rt.webp" alt=""
                  class="ml-2"></a>
            </div>
          </div>
          <!-- open sidebar menu -->
          <a class="btn btn-primary btn-customized open-menu ms-lg-0 d-xl-none" href="#" role="button">
            <i class="fas fa-align-left"></i>
          </a>
          </div>
        </div>
      </div>

      <div class="needHelp">
        <div class="container-fluid px-lg-5 text-center">
          <div class="needHelp-Search">
            <div class="needHelp-sec">
              <p class="mb-0"> <img src="<?php echo get_template_directory_uri(); ?>/assets/img/phone-receiver-silhouette.webp" alt=""> Need help? Give us a call on <a href="tel:08009949534">0800 994 9534</a></p>
            </div>
            <div class="search-section">
              <div class="search-container position-relative">
                <form class="d-flex align-items-center">
                  <input class="form-control search-input" type="search" placeholder="Search UK Glaze..."
                    aria-label="Search">
                  <button class="btn btn-search ms-2" type="submit">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none"
                      stroke="#fff" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                      class="search-icon feather feather-search">
                      <circle cx="11" cy="11" r="8"></circle>
                      <line x1="21" y1="21" x2="16.65" y2="16.65"></line>
                    </svg>
                  </button>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </header><!-- End Header -->
  </div>