<?php /*Template Name: Home Page*/
get_header(); ?>
<!-- ======= Hero Section ======= -->
  <section class="hero py-0">
    <div class="hero-banner owl-carousel owl-theme">
      <div class="item">
        <img src="<?php echo get_template_directory_uri(); ?>/assets/img/slide-01.webp" alt="" class="img-fluid">
        <div class="bnrCptn_sec">
          <div class="container">
            <div class="row">
              <div class="col-md-12">
                <div class="bnrCnt_sec">
                  <div class="bespoke-glass">Bespoke Glass</div>
                  <div class="btnTitle">Balustrades</div>
                </div>
              </div>
              <div class="col-md-12 d-flex justify-content-end">
                <div class="high-qult">
                  <p>High-quality glass balustrade panels. The perfect fit for any indoor or outdoor project.</p>
                  <div class="secbtn mt-4">
                    <a href="#" class="btn btn-info">Show Glass Balustrades Now <img src="<?php echo get_template_directory_uri(); ?>/assets/img/arrow-rt.webp" alt=""></a>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <!-- <div class="dts">
      <div class="container">
        <div class="owl-dots" id="custom-owl-dots">
          <button role="button" class="owl-dot">
            <span></span>
          </button>
          <button role="button" class="owl-dot">
            <span></span>
          </button>
        </div>
      </div>
    </div>
    <div class="owl-nav">
      <div class="container">
        <button type="button" role="presentation" class="owl-prev">
          <i class="fa-solid fa-angle-left"></i>
        </button>
        <button type="button" role="presentation" class="owl-next">
          <i class="fa-solid fa-angle-right"></i>
        </button>
      </div>
    </div> -->
  </section>
  <!-- End Hero -->
  <main id="main">
    <section class="shop-by-glass-type">
      <div class="container-fluid px-lg-5">
        <div class="dftl-header text-center mb-5">
          <h2>Shop by Glass Type</h2>
          <p class="mt-4">Click below to view products and prices.</p>
        </div>
        <div class="row">
          <div class="col-sm-6 col-lg-3">
            <div class="shop-card">
              <a href="#">
                <img src="<?php echo get_template_directory_uri(); ?>/assets/img/fire-rated-glass.webp" alt="" class="img-fluid">
                <div class="overlay-text overlay-text-1"></div>
                <h4>Fire Rated Glass</h4>
              </a>
            </div>
          </div>
          <div class="col-sm-6 col-lg-3 mt-4 mt-sm-0">
            <div class="shop-card">
              <a href="#">
                <img src="<?php echo get_template_directory_uri(); ?>/assets/img/laminated-glass.webp" alt="" class="img-fluid">
                <div class="overlay-text overlay-text-1"></div>
                <h4>Laminated Glass</h4>
              </a>
            </div>
          </div>
          <div class="col-sm-6 col-lg-3 mt-4 mt-lg-0">
            <div class="shop-card">
              <a href="#">
                <img src="<?php echo get_template_directory_uri(); ?>/assets/img/glass-balustrade.webp" alt="" class="img-fluid">
                <div class="overlay-text overlay-text-1"></div>
                <h4>Glass Balustrade</h4>
              </a>
            </div>
          </div>
          <div class="col-sm-6 col-lg-3 mt-4 mt-lg-0">
            <div class="shop-card">
              <a href="#">
                <img src="<?php echo get_template_directory_uri(); ?>/assets/img/glass-shower-screens.webp" alt="" class="img-fluid">
                <div class="overlay-text overlay-text-1"></div>
                <h4>Glass Shower Screens</h4>
              </a>
            </div>
          </div>
        </div>
      </div>
    </section>
    <section class="shop-fittings-accessories pt-0">
      <div class="container">
        <div class="row">
          <div class="col-md-6">
            <div class="shop-fittings-card pe-lg-3">
              <div class="shpf-text mb-5">
                <h3>1. Shop Fittings & Accessories</h3>
                <a href="#">Our Range of Fittings and Accessories <img src="<?php echo get_template_directory_uri(); ?>/assets/img/fittings-and-accessories-arrow.webp" alt=""></a>
              </div>
              <img src="<?php echo get_template_directory_uri(); ?>/assets/img/shop-fittings-accessories.webp" alt="" class="img-fluid rounded-3">
            </div>
          </div>
          <div class="col-md-6 mt-4 mt-md-0">
            <div class="shop-fittings-card ps-lg-3">
              <img src="<?php echo get_template_directory_uri(); ?>/assets/img/shop-glass.webp" alt="" class="img-fluid rounded-3">
              <div class="shpf-text mt-4">
                <h3>2. Shop Glass </h3>
                <a href="#">Our Range of Glass </a>
              </div>
              
            </div>
          </div>
        </div>
      </div>
    </section>
    <section class="why-choose-us pb-0">
      <div class="container">
        <div class="dftl-header mb-5">
          <h2>Why Choose Us?</h2>
          <div class="secbtn d-flex gap-3">
            <a href="#" class="btn btn-info btn-black">Shop all products <img src="<?php echo get_template_directory_uri(); ?>/assets/img/arrow-rt.webp" alt=""></a>
          </div>
        </div>
        <div class="row">
          <div class="col-lg-5">
            <div class="why-choose-thumb">
              <img src="<?php echo get_template_directory_uri(); ?>/assets/img/why-choose-us-image.webp" alt="" class="img-fluid">
            </div>
          </div>
          <div class="col-lg-7">
            <div class="why-choose-content">
              <div class="row row-cols-2">
                <div class="col">
                  <div class="choose-us-content prb-0">
                    <div class="chose-us-icon">
                      <img src="<?php echo get_template_directory_uri(); ?>/assets/img/bespoke-sizes-icon.webp" alt="" class="img-fluid">
                    </div>
                    <h3 class="my-4">Bespoke Sizes</h3>
                    <p>Products available in any size, shape or finish for both commercial and residential projects.</p>
                  </div>
                </div>
                <div class="col">
                  <div class="choose-us-content plb-0">
                    <div class="chose-us-icon">
                      <img src="<?php echo get_template_directory_uri(); ?>/assets/img/quality-assured-icon.webp" alt="" class="img-fluid">
                    </div>
                    <h3 class="my-4">Quality Assured</h3>
                    <p>Guaranteed high-quality products and services certified with BSI.</p>
                  </div>
                </div>
                <div class="col">
                  <div class="choose-us-content prt-0">
                    <div class="chose-us-icon">
                      <img src="<?php echo get_template_directory_uri(); ?>/assets/img/uk-manufactured.webp" alt="" class="img-fluid">
                    </div>
                    <h3 class="my-4">UK Manufactured</h3>
                    <p>All products manufactured and designed on-site in the South East of England.</p>
                  </div>
                </div>
                <div class="col">
                  <div class="choose-us-content plt-0">
                    <div class="chose-us-icon">
                      <img src="<?php echo get_template_directory_uri(); ?>/assets/img/hour-quotation-service.webp" alt="" class="img-fluid">
                    </div>
                    <h3 class="my-4">1 Hour Quotation Service</h3>
                    <p>Tell us what you need and get a quote within the hour.</p>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <section class="about-uk-glaze">
      <div class="container">
        <div class="row">
          <div class="col-md-6">
            <div class="about-ukg-thumb">
              <img src="<?php echo get_template_directory_uri(); ?>/assets/img/about-uk-glaze.webp" alt="" class="img-fluid">
            </div>
          </div>
          <div class="col-md-6 d-lg-flex align-items-center mt-5 mt-md-0">
            <div class="about-ukg-content ps-lg-5">
              <h2 class="mb-4">About UK Glaze</h2>
              <h5 class="mb-4">At UK Glaze, we take pride in being one of the London’s premier providers of bespoke glass solutions.</h5>
              <p>From toughening and processing to laminating, painting, and precision printing, we specialise in crafting high-quality glass products tailored to your exact specifications.</p>
              <p>Whether you're transforming a home, designing a commercial interior, or tackling a one-of-a-kind project, we offer an extensive selection—from sleek frameless mirrors to durable fire-rated glass—all available in custom sizes and finishes to suit any space.</p>
              <p>To help you complete your vision with ease, we also supply a full range of glass fittings and accessories, ensuring every installation is as smooth and seamless as the glass itself.</p>
              <div class="secbtn mt-5 d-flex gap-3">
                <a href="#" class="btn btn-info">view Gallery <img src="<?php echo get_template_directory_uri(); ?>/assets/img/arrow-rt.webp" alt=""></a>
                <a href="#" class="btn btn-info btn-black">Get in touch <img src="<?php echo get_template_directory_uri(); ?>/assets/img/arrow-rt.webp" alt=""></a>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <section class="see_our_gallery">
      <div class="container">
        <div class="row">
          <div class="col-lg-3 d-lg-flex align-items-center">
            <div class="glryTitle">
              <h2 class="mb-lg-4">See <br>Our Gallery</h2>
              <p>Take a look at some inspiration</p>
              <div class="secbtn mt-5 d-flex">
                <a href="#" class="btn btn-info">view Gallery <img src="<?php echo get_template_directory_uri(); ?>/assets/img/arrow-rt.webp" alt=""></a>
              </div>
            </div>
          </div>
          <div class="col-lg-9">
            <div class="glryPic" id="see_our_gallery">
              <!-- Gallery -->
              <div class="row">
                <div class="col-lg-4 col-md-12 mb-4 mb-lg-0">
                  <a href="assets/img/gallery-big-01.webp">
                    <img src="<?php echo get_template_directory_uri(); ?>/assets/img/gallery-thumb-01.webp" alt="" class="w-100 shadow-1-strong rounded mb-4 img-fluid">
                  </a>
                  <a href="assets/img/gallery-big-02.webp">
                    <img src="<?php echo get_template_directory_uri(); ?>/assets/img/gallery-thumb-02.webp" alt="" class="w-100 shadow-1-strong rounded mb-4 img-fluid">
                  </a>
                </div>

                <div class="col-lg-4 mb-4 mb-lg-0">
                  <a href="assets/img/gallery-big-03.webp">
                    <img src="<?php echo get_template_directory_uri(); ?>/assets/img/gallery-thumb-03.webp" alt="" class="w-100 shadow-1-strong rounded mb-4 img-fluid">
                  </a>
                </div>

                <div class="col-lg-4 mb-4 mb-lg-0">
                  <a href="assets/img/gallery-big-04.webp">
                    <img src="<?php echo get_template_directory_uri(); ?>/assets/img/gallery-thumb-04.webp" alt="" class="w-100 shadow-1-strong rounded mb-4 img-fluid">
                  </a>
                  <a href="assets/img/gallery-big-05.webp">
                    <img src="<?php echo get_template_directory_uri(); ?>/assets/img/gallery-thumb-05.webp" alt="" class="w-100 shadow-1-strong rounded mb-4 img-fluid">
                  </a>
                </div>
              </div>
              <!-- Gallery -->
            </div>
          </div>
        </div>
      </div>
    </section>
    <section class="your-trusted-experts">
      <div class="container-fluid">
        <div class="row">
          <div class="col-lg-3 d-lg-flex align-items-lg-end">
            <div class="ytex-thumb">
              <img src="<?php echo get_template_directory_uri(); ?>/assets/img/your-trusted-experts.webp" alt="" class="img-fluid rounded-3">
            </div>
          </div>
          <div class="col-lg-3 order-lg-1 d-lg-flex align-items-lg-center mt-4 mt-lg-0">
            <div class="ytex-thumb text-center">
              <img src="<?php echo get_template_directory_uri(); ?>/assets/img/bespoke-glass-solutions.webp" alt="" class="img-fluid rounded-3">
            </div>
          </div>
          <div class="col-lg-6">
            <div class="your-trusted-experts-content text-center px-xl-5 pb-lg-5 mt-5 mt-lg-0">
              <h2 class="mb-4">Your Trusted Experts In Bespoke Glass Solutions</h2>
              <h5 class="mb-4">UK Glaze is proud to be one of the London's leading specialists in bespoke glass toughening, processing, laminating, painting, printing, and mirror supply.</h5>
              <p>Whether you're updating your home, fitting out a commercial space, or working on a custom project, we offer a comprehensive range of high-quality glass products tailored to your needs.</p>
              <p>From frameless mirrors to fire-rated glass and everything in between, we supply glass in custom sizes and finishes to suit both residential and commercial applications.</p>
              <p>To make installation simple, we also provide a selection of glass fittings and accessories, ensuring you have everything you need to complete your project with ease and confidence.</p>
              <div class="secbtn mt-5 d-flex justify-content-center">
                <a href="#" class="btn btn-info">Shop glass products <img src="<?php echo get_template_directory_uri(); ?>/assets/img/arrow-rt.webp" alt=""></a>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <section class="customer-testimonials">
      <div class="container">
        <div class="dflt-header mb-5">
          <h2>Customer Testimonials</h2>
          <div class="owl-nav">
            <button type="button" role="presentation" class="owl-prev">
              <i class="fa-solid fa-angle-left"></i>
            </button>
            <button type="button" role="presentation" class="owl-next">
              <i class="fa-solid fa-angle-right"></i>
            </button>
          </div>
        </div>
        <div class="owl-carousel owl-theme" id="customer-testmls">
          <div class="item">
            <div class="cstmr-testmls ">
              <img src="<?php echo get_template_directory_uri(); ?>/assets/img/testmls-quote.webp" alt="" class="img-fluid mb-4">
              <p>Extremely easy company to deal with, glass ordered weeks ago and asked for a specific delivery date due to glass testing and no one being onsite. Delivered on time and when asked for other types glass stated they couldn’t help but recommended an equally helpful company!!</p>
              <p>wouldn’t hesitate to use again.</p>
              <h4 class="mt-4">Andy Beviere</h4>
              <p>United Kingdom</p>
            </div>
          </div>
          <div class="item">
            <div class="cstmr-testmls ">
              <img src="<?php echo get_template_directory_uri(); ?>/assets/img/testmls-quote.webp" alt="" class="img-fluid mb-4">
              <p>Extremely easy company to deal with, glass ordered weeks ago and asked 
for a specific delivery date due to glass testing and no one being onsite. Delivered on time and when asked for other types glass stated they couldn’t help but recommended an equally helpful company!!</p>
              <p>wouldn’t hesitate to use again.</p>
              <h4 class="mt-4">Andy Beviere</h4>
              <p>United Kingdom</p>
            </div>
          </div>
        </div>
      </div>
    </section>
    <section class="brandLogo_sec py-5">
        <div class="container-fluid px-lg-5">
          <div class="row">
            <div class="col-6 col-sm-2">
              <div class="brand_logo">
                <img src="<?php echo get_template_directory_uri(); ?>/assets/img/brand-logo-01.webp" alt="" class="img-fluid rounded-2">
              </div>
            </div>
            <div class="col-6 col-sm-2">
              <div class="brand_logo">
                <img src="<?php echo get_template_directory_uri(); ?>/assets/img/brand-logo-02.webp" alt="" class="img-fluid">
              </div>
            </div>
            <div class="col-6 col-sm-2">
              <div class="brand_logo">
                <img src="<?php echo get_template_directory_uri(); ?>/assets/img/brand-logo-03.webp" alt="" class="img-fluid">
              </div>
            </div>
            <div class="col-6 col-sm-2">
              <div class="brand_logo">
                <img src="<?php echo get_template_directory_uri(); ?>/assets/img/brand-logo-04.webp" alt="" class="img-fluid">
              </div>
            </div>
            <div class="col-6 col-sm-2">
              <div class="brand_logo">
                <img src="<?php echo get_template_directory_uri(); ?>/assets/img/brand-logo-05.webp" alt="" class="img-fluid">
              </div>
            </div>
            <div class="col-6 col-sm-2">
              <div class="brand_logo">
                <img src="<?php echo get_template_directory_uri(); ?>/assets/img/brand-logo-06.webp" alt="" class="img-fluid">
              </div>
            </div>
            <div class="col-6 col-sm-2">
              <div class="brand_logo">
                <img src="<?php echo get_template_directory_uri(); ?>/assets/img/brand-logo-07.webp" alt="" class="img-fluid">
              </div>
            </div>
          </div>
        </div>
    </section>
  </main><!-- End #main -->
<?php get_footer();