<?php /*Template Name: Shop Details*/
get_header(); ?>


<main id="main">
    <div class="shop_product_details">
      <div class="breadcrumbs">
        <div class="container">
          <ol>
            <li><a href="#">Home</a></li>
            <li><a href="#">Shop</a></li>
            <li>Toughened Glass Partitions</li>
          </ol>
        </div>
      </div>
      <div class="shop_product_details_row pb-5 mb-3" id="sp_dtls_gallery">
        <div class="container">
          <div class="row">
            <div class="col-lg-6">
              <div class="sp_dtls_product-gallery">
                <div class="glryThumb">
                  <a href="assets/img/product-dtls-thumb.webp">
                    <img src="<?php echo get_template_directory_uri(); ?>/assets/img/product-dtls-thumb.webp" alt="" class="img-fluid">
                  </a>
                </div>
              </div>
            </div>
            <div class="col-lg-6">
              <div class="sp_dtls_summery">
                <h1>Toughened Glass Partitions</h1>
                <h5>Product Description</h5>
                <div class="sp_short_ddetails__short-description">
                  <p>Separate interior spaces in style with glass partitions. Open floor plans are popular in contemporary buildings, but they don’t always offer much versatility when you need a more private area to work, converse, or relax. This can leave people feeling exposed – especially in an office environment.</p>
                  <a href="#" class="spd_link">(Read More)</a>
                </div>
                <div class="glr_viewBtn d-none d-md-block mt-4 mb-4">
                  <a href="#" class="btn btn-info">Build/Buy Online Now! <i class="fa-solid fa-angle-right"></i></a>
                </div>
                <ul class="sp_prdtListing">
                  <li>
                    <i class="fa-solid fa-check"></i>
                    Express Delivery available on this product.
                  </li>
                  <li>
                    <i class="fa-solid fa-check"></i>
                    This product is manufactured in the UK.
                  </li>
                  <li>
                    <i class="fa-solid fa-check"></i>
                    Toughened Glass.
                  </li>
                  <li>
                    <i class="fa-solid fa-check"></i>
                    Polished edges included.
                  </li>
                </ul>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="accordion-wizard-form mt-5">
        <div class="container">
          <form id="wizard-form" method="post">

            <div class="list-group">

              <div class="list-group-item" data-acc-step>
                <div class="listHdr">
                  <label for="pa_glass-type">Step <span class="step-number">1</span> - Style: <span class="pre-selection-info">Click Here...</span></label>
                </div>
                <div data-acc-content>
                  <div class="wizardForm-content py-5">
                    <div class="variation-header text-center pa_glass-type mb-5">
                      <h3 class="main-heading">Please Select The Style Below</h3>
                    </div>
                    <div class="row">
                      <div class="col-sm-6 col-lg-3">
                        <div class="imgTooltip" onclick="selectRadio('option1')">
                            <img data-toggle="tooltip" title="Clear Toughened Glass" src="<?php echo get_template_directory_uri(); ?>/assets/img/Clear-Glass-600x400.webp" class="img-fluid" alt="Option 1">
                            <input type="radio" class="glass_title" name="glass_title" value="1" id="option1" style="display:none;">
                        </div>
                      </div>
                      <div class="col-sm-6 col-lg-3 mt-4 mt-sm-0">
                        <div class="imgTooltip" onclick="selectRadio('option2')">
                          <img data-toggle="tooltip" title="Clear Toughened Glass" src="<?php echo get_template_directory_uri(); ?>/assets/img/Clear-Glass-600x400.webp" class="img-fluid" alt="Option 2">
                            <input type="radio" class="glass_title" name="glass_title" value="2" id="option2" style="display:none;">
                        </div>
                      </div>
                      <div class="col-sm-6 col-lg-3 mt-4 mt-lg-0">
                        <div class="imgTooltip" onclick="selectRadio('option3')">
                          <img data-toggle="tooltip" title="Clear Toughened Glass" src="<?php echo get_template_directory_uri(); ?>/assets/img/Clear-Glass-600x400.webp" class="img-fluid" alt="Option 3">
                            <input type="radio" class="glass_title" name="glass_title" value="3" id="option3" style="display:none;">
                        </div>
                      </div>
                      <div class="col-sm-6 col-lg-3 mt-4 mt-lg-0">
                        <div class="imgTooltip" onclick="selectRadio('option4')">
                          <img data-toggle="tooltip" title="Clear Toughened Glass" src="<?php echo get_template_directory_uri(); ?>/assets/img/Clear-Glass-600x400.webp" class="img-fluid" alt="Option 4">
                            <input type="radio" class="glass_title" name="glass_title" value="4" id="option4" style="display:none;">
                        </div>
                      </div>
                    </div>
                    <!--<input type="submit" class="sub_btn" name="sub_btn" value="submit">-->
                  </div>
                </div>
              </div>

              <div class="list-group-item" data-acc-step>
                <div class="listHdr">
                  <label for="pa_shape">Step <span class="step-number">2</span> - Shape: <span class="pre-selection-info">Click Here...</span></label>
                </div>
                <div data-acc-content>
                  <div class="wizardForm-content py-5">
                    <div class="variation-header text-center pa_glass-type mb-5">
                      <h3 class="main-heading">Please Select The Style Below</h3>
                    </div>
                    <div class="row">
                      <div class="col-sm-6 col-lg-3">
                        <div class="imgTooltip" onclick="selectStyle('style1')">
                          <img data-toggle="tooltip" title="Rectangle" src="<?php echo get_template_directory_uri(); ?>/assets/img/shape-rectangle.svg" class="img-fluid" alt="Style 1">
                            <input type="radio" class="style_title" name="style_title" value="1" id="style1" style="display:none;">
                        </div>
                      </div>
                      <div class="col-sm-6 col-lg-3 mt-4 mt-sm-0">
                        <div class="imgTooltip" onclick="selectStyle('style2')">
                          <img data-toggle="tooltip" title="Left Hand Rake" src="<?php echo get_template_directory_uri(); ?>/assets/img/shape-rectangle.svg" class="img-fluid" alt="Style 2">
                            <input type="radio" class="style_title" name="style_title" value="2" id="style2" style="display:none;">
                        </div>
                      </div>
                      <div class="col-sm-6 col-lg-3 mt-4 mt-lg-0">
                        <div class="imgTooltip" onclick="selectStyle('style3')">
                          <img data-toggle="tooltip" title="Right Hand Rake" src="<?php echo get_template_directory_uri(); ?>/assets/img/shape-rectangle.svg" class="img-fluid" alt="Style 3">
                            <input type="radio" class="style_title" name="style_title" value="3" id="style3" style="display:none;">
                        </div>
                      </div>
                      <div class="col-sm-6 col-lg-3 mt-4 mt-lg-0">
                        <div class="imgTooltip" onclick="selectStyle('style4')">
                          <img data-toggle="tooltip" title="Double Rake Irregular" src="<?php echo get_template_directory_uri(); ?>/assets/img/shape-rectangle.svg" class="img-fluid" alt="Style 4">
                            <input type="radio" class="style_title" name="style_title" value="4" id="style4" style="display:none;">
                        </div>
                      </div>
                      
                    </div>
                  </div>
                </div>
              </div>

              <div class="list-group-item" data-acc-step>
                <div class="listHdr">
                  <label for="dimensions">Step <span class="step-number">3</span> - Dimensions &amp; Extras: <span class="pre-selection-info">Click Here...</span></label>
                </div>
                <div data-acc-content>
                  <div class="wizardForm-content py-5">
                    <div class="variation-header text-center pa_glass-type mb-5">
                      <h3 class="main-heading">Please fill in the dimensions below</h3>
                      <p>(Please note to allow a 2mm tolerance in all designs. <br>
                        All internal notches will have a 7mm radius to ensure structural integrity during the toughening process.)</p>
                    </div>
                    <div class="rightHandRake">
                      <div class="pewc-group-heading-wrapper text-center"><h3>Right Hand Rake</h3></div>
                      <div class="pewc-group-content-wrapper">
                        <ul class="pewc-product-extra-groups mmtext ppegroups">
                          <li class="pewc-item pewc-group pewc-group-number pewc-item-number pewc-has-field-image pewc-calculation-trigger pewc-field-triggers-condition">
                            <div class="pewc-item-field-image-wrapper">
                              <img src="<?php echo get_template_directory_uri(); ?>/assets/img/express-paralleogram-01.svg" alt="" class="img-fluid">
                            </div>
                            <div class="pewc-item-field-wrapper">
                              <h4 class="pewc-field-label" for="pewc_group_1736_1737">A<span class="required"> *</span></h4>
                              <input type="number" class="size_a pewc-form-field pewc-number-field pewc-number-field-1737" id="pewc_group_1736_1737" name="pewc_group_1736_1737" value="" min="10" max="1499" step="1" autocomplete="off" data-require-required="yes">
                              <p class="pewc-description"><small>Min: 10</small><small>Max: 1499</small></p>
                            </div>
                          </li>
                          <li class="pewc-item pewc-group pewc-group-number pewc-item-number pewc-calculation-trigger">
                            <div class="pewc-item-field-wrapper">
                              <h4 class="pewc-field-label" for="pewc_group_1736_1738">B<span class="required"> *</span></h4>
                              <input type="number" class="size_b pewc-form-field pewc-number-field pewc-number-field-1738" id="pewc_group_1736_1738" name="pewc_group_1736_1738" value="" min="250" max="3000" step="1" autocomplete="off" data-require-required="yes">
                              <div class="dimension-notes"></div>
                              <p class="pewc-description"><small>Min: 250</small><small>Max: 3000</small></p>
                            </div>
                          </li>
                          <li class="pewc-items pewc-group pewc-group-number pewc-item-number">

                            <div class="pewc-item-field-wrapper">
                              <h4 class="pewc-field-label" for="pewc_group_1736_1739">C<span class="required"> *</span></h4>
                              <input type="number" class="size_c pewc-form-field pewc-number-field pewc-number-field-1739" id="pewc_group_1736_1739" name="pewc_group_1736_1739" value="" min="100" max="1500" step="1" autocomplete="off" data-require-required="yes">
                              <div class="dimension-notes"></div>
                              <p class="pewc-description"><small>Min: 100</small><small>Max: 1500</small></p>
                            </div>
                          </li>
                        </ul>
                      </div>
                        
                      <!--<div class="pewcGroup pewc-group-wrap pewc-group-wrap-1767 py-5">
                        <div class="pewc-group-heading-wrapper text-center">
                          <h3>Please select product extras if required</h3>
                        </div>
                        <div class="pewc-group-content-wrapper">
                          <ul class="pewc-product-extra-groups">
                            <li class="pewc-item pewc-group-checkbox pewc-item-checkbox" data-toggle="collapse" data-target=".sec-1">
                              <div class="pewc-item-field-wrapper">
                                <label for="pewc_group_1767_1768">
                                  <input type="checkbox" class="pewc-form-field" id="pewc_group_1767_1768" name="pewc_group_1767_1768" value="__checked__">&nbsp;
                                  <span>Do you need internal cut outs?<span class="required"> *</span></span>
                                  <span class="pewc-theme-element"></span>
                                </label>
                              </div>
                            </li>
                            <li class="pewc-item pewc-group pewc-group-number pewc-item-number pewc-has-field-price pewc-multiply-pricing pewc-has-field-image pewc-hidden-field pewc-field-has-condition sec-1">

                              <div class="pewc-item-field-image-wrapper">
                                <img src="<?php echo get_template_directory_uri(); ?>/assets/img/Cut-Out.svg" alt="" class="img-fluid">
                              </div>
                              <div class="pewc-item-field-wrapper">
                                <h4 class="pewc-field-label" for="pewc_group_1767_1769">Quantity
                                  <span class="required"> *</span>
                                  <span class="pewc-field-price"> 
                                    <span class="woocommerce-Price-currencySymbol">£</span>19.00</span>
                                </h4>
                                <input type="number" class="pewc-form-field pewc-number-field pewc-number-field-1769" id="pewc_group_1767_1769" name="pewc_group_1767_1769" value="" min="1" max="" step="1" autocomplete="off" data-require-required="yes">
                                <div class="dimension-notes"></div>
                                <p class="pewc-description">Cut outs should not be smaller than the thickness of the glass, or closer to the edge than 2.5 times the thickness of the glass, or larger than 30% of overall glass size. A customer service representative will contact you regarding your exact requirements if needed. Please upload any drawings if possible. Please upload any drawings below if possible.</a>
                                </p>
                              </div>
                            </li>
                            <li class="pewc-item pewc-group-checkbox pewc-item-checkbox" data-toggle="collapse" data-target=".sec-2">
                              <div class="pewc-item-field-wrapper">
                                <label for="pewc_group_1767_1768">
                                  <input type="checkbox" class="pewc-form-field" id="pewc_group_1767_1768" name="pewc_group_1767_1768" value="__checked__">&nbsp;
                                  <span>Do you need notches or hinges?<span class="required"> *</span></span>
                                  <span class="pewc-theme-element"></span>
                                </label>
                              </div>
                            </li>
                            <li class="pewc-item pewc-group pewc-group-number pewc-item-number pewc-has-field-price pewc-multiply-pricing pewc-has-field-image pewc-hidden-field pewc-field-has-condition sec-2">

                              <div class="pewc-item-field-image-wrapper">
                                <img src="<?php echo get_template_directory_uri(); ?>/assets/img/Notches.svg" alt="" class="img-fluid">
                              </div>
                              <div class="pewc-item-field-wrapper">
                                <h4 class="pewc-field-label" for="pewc_group_1767_1769">Quantity
                                  <span class="required"> *</span>
                                  <span class="pewc-field-price"> 
                                    <span class="woocommerce-Price-currencySymbol">£</span>19.00</span>
                                </h4>
                                <input type="number" class="pewc-form-field pewc-number-field pewc-number-field-1769" id="pewc_group_1767_1769" name="pewc_group_1767_1769" value="" min="1" max="" step="1" autocomplete="off" data-require-required="yes">
                                <div class="dimension-notes"></div>
                                <p class="pewc-description">Cut outs should not be smaller than the thickness of the glass, or closer to the edge than 2.5 times the thickness of the glass, or larger than 30% of overall glass size. A customer service representative will contact you regarding your exact requirements if needed. Please upload any drawings if possible. Please upload any drawings below if possible.</a>
                                </p>
                              </div>
                            </li>
                            <li class="pewc-item pewc-group-checkbox pewc-item-checkbox" data-toggle="collapse" data-target=".sec-3">
                              <div class="pewc-item-field-wrapper">
                                <label for="pewc_group_1767_1768">
                                  <input type="checkbox" class="pewc-form-field" id="pewc_group_1767_1768" name="pewc_group_1767_1768" value="__checked__">&nbsp;
                                  <span>Do you need drilled holes?<span class="required"> *</span></span>
                                  <span class="pewc-theme-element"></span>
                                </label>
                              </div>
                            </li>
                            <li class="pewc-item pewc-group pewc-group-number pewc-item-number pewc-has-field-price pewc-multiply-pricing pewc-has-field-image pewc-hidden-field pewc-field-has-condition sec-3">
                              <div class="pewc-item-field-wrapper">
                                <h4 class="pewc-field-label" for="pewc_group_1767_1776">Quantity<span class="required"> *</span><span class="pewc-field-price"> <span class="woocommerce-Price-currencySymbol">£</span>4.00</span>
                                </h4><input type="number" class="pewc-form-field pewc-number-field pewc-number-field-1776" id="pewc_group_1767_1776" name="pewc_group_1767_1776" value="" min="1" max="" step="1" autocomplete="off" data-require-required="yes">
                                <div class="dimension-notes"></div>
                              </div>
                              <div class="pewc-item-field-image-wrapper">
                                <img src="<?php echo get_template_directory_uri(); ?>/assets/img/Drill-Holes.svg" alt="" class="img-fluid">
                              </div>
                              <div class="pewc-item-field-wrapper">
                                <h4 class="pewc-field-label" for="pewc_group_1767_1769">Quantity
                                  <span class="required"> *</span>
                                  <span class="pewc-field-price"> 
                                    <span class="woocommerce-Price-currencySymbol">£</span>19.00</span>
                                </h4>
                                <input type="number" class="pewc-form-field pewc-number-field pewc-number-field-1769" id="pewc_group_1767_1769" name="pewc_group_1767_1769" value="" min="1" max="" step="1" autocomplete="off" data-require-required="yes">
                                <div class="dimension-notes"></div>
                                <p class="pewc-description">Cut outs should not be smaller than the thickness of the glass, or closer to the edge than 2.5 times the thickness of the glass, or larger than 30% of overall glass size. A customer service representative will contact you regarding your exact requirements if needed. Please upload any drawings if possible. Please upload any drawings below if possible.</a>
                                </p>
                              </div>
                            </li>
                            <li class="pewc-item pewc-group-checkbox pewc-item-checkbox" data-toggle="collapse" data-target=".sec-4">
                              <div class="pewc-item-field-wrapper">
                                <label for="pewc_group_1767_1768">
                                  <input type="checkbox" class="pewc-form-field" id="pewc_group_1767_1768" name="pewc_group_1767_1768" value="__checked__">&nbsp;
                                  <span>Do you need radius corners?<span class="required"> *</span></span>
                                  <span class="pewc-theme-element"></span>
                                </label>
                              </div>
                            </li>
                            <li class="pewc-item pewc-group pewc-group-number pewc-item-number pewc-has-field-price pewc-multiply-pricing pewc-has-field-image pewc-hidden-field pewc-field-has-condition sec-4">
                              <div class="pewc-item-field-wrapper"><h4 class="pewc-field-label" for="pewc_group_1767_1779">Quantity<span class="required"> *</span><span class="pewc-field-price"> <span class="woocommerce-Price-currencySymbol">£</span>7.50</span></h4><input type="number" class="pewc-form-field pewc-number-field pewc-number-field-1779" id="pewc_group_1767_1779" name="pewc_group_1767_1779" value="" min="1" max="" step="1" autocomplete="off" data-require-required="yes"><div class="dimension-notes"></div></div>
                              <div class="pewc-item-field-image-wrapper">
                                <img src="<?php echo get_template_directory_uri(); ?>/assets/img/Drill-Holes.svg" alt="" class="img-fluid">
                              </div>
                              <div class="pewc-item-field-wrapper">
                                <h4 class="pewc-field-label" for="pewc_group_1767_6637">Radius Corner Size
                                  <span class="required"> *</span>
                                </h4>
                                <input type="number" class="pewc-form-field pewc-number-field pewc-number-field-6637" id="pewc_group_1767_6637" name="pewc_group_1767_6637" value="" min="5" max="50" step="5" autocomplete="off" data-require-required="yes">
                                <div class="dimension-notes"></div>
                                <p class="pewc-description">A rounded corner with a polished finish.
                                  A customer service representative will contact you regarding your exact requirements if needed. <a class="drawing-button smooth-scroll">Please upload any drawings below if possible.</a></p>
                                </p>
                              </div>
                            </li>
                            <li class="pewc-item pewc-group-checkbox pewc-item-checkbox" data-toggle="collapse" data-target=".sec-5">
                              <div class="pewc-item-field-wrapper">
                                <label for="pewc_group_1767_1768">
                                  <input type="checkbox" class="pewc-form-field" id="pewc_group_1767_1768" name="pewc_group_1767_1768" value="__checked__">&nbsp;
                                  <span>Do you need dubbed corners?<span class="required"> *</span></span>
                                  <span class="pewc-theme-element"></span>
                                </label>
                              </div>
                            </li>
                            <li class="pewc-item pewc-group pewc-group-number pewc-item-number pewc-has-field-price pewc-multiply-pricing pewc-has-field-image pewc-hidden-field pewc-field-has-condition sec-5">

                              <div class="pewc-item-field-image-wrapper">
                                <img src="<?php echo get_template_directory_uri(); ?>/assets/img/Dubbed-Corners.svg" alt="" class="img-fluid">
                              </div>
                              <div class="pewc-item-field-wrapper">
                                <h4 class="pewc-field-label" for="pewc_group_1767_1769">Quantity
                                  <span class="required"> *</span>
                                  <span class="pewc-field-price"> <span class="woocommerce-Price-currencySymbol">£</span>2.00</span>
                                </h4>
                                <input type="number" class="pewc-form-field pewc-number-field pewc-number-field-1769" id="pewc_group_1767_1769" name="pewc_group_1767_1769" value="" min="1" max="" step="1" autocomplete="off" data-require-required="yes">
                                <div class="dimension-notes"></div>
                                <p class="pewc-description">Sharpness of corner removed with grey finish.
                                  A customer service representative will contact you regarding your exact requirements if needed.</p>
                              </div>
                            </li>
                            <li class="pewc-item pewc-group-checkbox pewc-item-checkbox" data-toggle="collapse" data-target=".sec-6">
                              <div class="pewc-item-field-wrapper">
                                <label for="pewc_group_1767_1768">
                                  <input type="checkbox" class="pewc-form-field" id="pewc_group_1767_1768" name="pewc_group_1767_1768" value="__checked__">&nbsp;
                                  <span>Do you have diagrams drawings or specifications?<span class="required"> *</span></span>
                                  <span class="pewc-theme-element"></span>
                                </label>
                              </div>
                            </li>
                            <li class="pewc-item pewc-group pewc-group-number pewc-item-number pewc-has-field-price pewc-multiply-pricing pewc-has-field-image pewc-hidden-field pewc-field-has-condition sec-6">

                              <div class="pewc-item-field-image-wrapper">
                                <img src="<?php echo get_template_directory_uri(); ?>/assets/img/Dubbed-Corners.svg" alt="" class="img-fluid">
                              </div>
                              <div class="pewc-item-field-wrapper">
                                <h4 class="pewc-field-label" for="pewc_group_1767_1780">File Uploads<span class="required"> *</span></h4>

                                <div id="dropzone">
                                  <form>
                                    <fieldset class="upload_dropZone text-center mb-3 p-4">
                                      <legend class="visually-hidden">Image uploader</legend>
                                      <p class="small my-2">Drag &amp; Drop background image(s) inside dashed region<br><i>or</i></p>
                                      <input id="upload_image_background" data-post-name="image_background" data-post-url="https://someplace.com/image/uploads/backgrounds/" class="position-absolute invisible" type="file" multiple accept="image/jpeg, image/png, image/svg+xml" />
                                  
                                      <label class="btn btn-upload mb-3" for="upload_image_background">Choose file(s)</label>
                                      <div class="upload_gallery d-flex flex-wrap justify-content-center gap-3 mb-0"></div>
                                    </fieldset>
                                  </form>
                                </div>
                                <div class="dimension-notes"></div>
                                <p class="pewc-description">Sharpness of corner removed with grey finish.
                                  A customer service representative will contact you regarding your exact requirements if needed.</p>
                              </div>
                            </li>
                            <li class="pewc-item pewc-group-checkbox pewc-item-checkbox" data-toggle="collapse" data-target=".sec-7">
                              <div class="pewc-item-field-wrapper">
                                <label for="pewc_group_1767_1768">
                                  <input type="checkbox" class="pewc-form-field" id="pewc_group_1767_1768" name="pewc_group_1767_1768" value="__checked__">&nbsp;
                                  <span>Do you need polymer coating?<span class="required"> *</span></span>
                                  <span class="pewc-theme-element"></span>
                                </label>
                              </div>
                            </li>
                            <li class="pewc-item pewc-group pewc-group-number pewc-item-number pewc-has-field-price pewc-multiply-pricing pewc-has-field-image pewc-hidden-field pewc-field-has-condition sec-7 flex-column">
                              <p class="rtgleplmr_list">Rectangle Polymer *</p>
                              <p class="rtgleplmr_list">Semi Circle Polymer *</p>
                              <p class="rtgleplmr_list">Parallelogram Polymer</p>
                              <p class="rtgleplmr_list">Quadrant Polymer *</p>
                              <p class="rtgleplmr_list">Ellipse Polymer *</p>
                              <p class="rtgleplmr_list">Circle Polymer *</p>
                              <p class="rtgleplmr_list">Cut Off Corner Rectangle Right Polymer *</p>
                              <p class="rtgleplmr_list">Cut Off Corner Rectangle Left Polymer *</p>
                              <p class="rtgleplmr_list">Right Hand L Polymer *</p>
                              <p class="rtgleplmr_list">Left Hand L Polymer *</p>
                              <p class="rtgleplmr_list">Reverse Poylmer *</p>
                              <p class="rtgleplmr_list">Right Hand Rake Polymer *</p>
                              <p class="rtgleplmr_list">Left Hand Rake Polymer *</p>
                              <p class="rtgleplmr_list">Triangle Polymer *</p>
                              <p class="rtgleplmr_list">Semi Ellipse Polymer *</p>
                            </li>
                          </ul>
                        </div>
                      </div>-->
                      
                    </div>
                  </div>
                </div>
              </div>

              <div class="list-group-item" data-acc-step>
                <div class="listHdr">
                  <label for="pa_thickness">Step <span class="step-number">4</span> - Thickness: <span class="pre-selection-info">Click Here...</span></label>
                </div>
                <div data-acc-content>
                  <div class="plsslct-below py-5">
                    <div class="variation-header pa_thickness text-center mb-5">
                      <h3 class="main-heading">Please Select The Thickness Below</h3>
                    </div>
                    <div class="thicknessBelow">
                      <div class="row justify-content-center">
                        <div class="col-sm-4 col-lg-2">
                          <div class="thkblw_item clickable-div" data-val="10mm">
                            <h5>10mm</h5>
                          </div>
                        </div>
                        <div class="col-sm-4 col-lg-2 mt-4 mt-sm-0">
                          <div class="thkblw_item clickable-div" data-val="8mm">
                            <h5>8mm</h5>
                          </div>
                        </div>
                        <div class="col-sm-4 col-lg-2 mt-4 mt-sm-0">
                          <div class="thkblw_item clickable-div" data-val="12mm">
                            <h5>12mm</h5>
                          </div>
                        </div>
                        <div class="col-sm-4 col-lg-2 mt-4 mt-lg-0">
                          <div class="thkblw_item clickable-div" data-val="15mm">
                            <h5>15mm</h5>
                          </div>
                        </div>
                        <div class="col-sm-4 col-lg-2 mt-4 mt-lg-0">
                          <div class="thkblw_item clickable-div" data-val="19mm">
                            <h5>19mm</h5>
                          </div>
                        </div>
                      </div>
                      <input type="hidden" name="thik_ness" class="thik_ness" />
                      <input type="submit" class="sub_btn" name="sub_btn" value="submit">
                    </div>
                  </div>
                </div>
              </div>

            </div>

          </form>
        </div>
      </div>
      <div class="for_express pricing-shipping-alert py-4">
        <div class="container">
          <p class="frexp_text">For express 24/48 hour delivery, call 
            <a href="tel:020-8500-1188" class="phone" rel="nofollow" title="Call us!"> 020-8500-1188</a>			
          </p>
          <small class="pricing-note">
            <strong>Please note</strong> <br>
            <em>All bespoke glass pieces are subject to a minimum charge of £30 each, which will be adjusted at checkout if necessary.</em>
          </small>
        </div>
      </div>
      <!--<div class="single_variation_wrap_section">
        <div class="container">
          <div class="single_variation_wrap">
            <p class="total-cost-variations mb-0">Your Order Subtotal:</p>
            <p class="price pewc-main-price mb-0">
              <span class="sp-Price-amount amount"><bdi>
                <span class="sp-Price-currencySymbol">£</span>0.00</bdi>
              </span>
            </p>
            <div class="sp-variation-add-to-cart">
              <div class="quantity">
                <label class="screen-reader-text">QTY </label>
              <input type="number" id="quantity_669a8b826839b" class="input-text qty text" name="quantity" value="1" aria-label="Product quantity" size="4" min="1" max="" step="1" placeholder="" inputmode="numeric" autocomplete="off" data-gtm-form-interact-field-id="0">
              </div>
              <div class="glr_viewBtn glr_viewBtns">
                <a href="#" class="btn btn-info">Build/Buy Online Now! <i class="fa-solid fa-angle-right"></i></a>
              </div>
            </div>
          </div>
        </div>
      </div>-->
      
      <div class="productFaq_sec">
        <div class="container">
          <div class="prdtText">
            <h4>Product FAQ's</h4>
          </div>
          <div class="faqs-introduction pt-4 mb-4">
            <h2 class="main-heading">Frequently Asked Questions</h2>			
            <div class="article-content">See our most frequently asked questions below.</div>
          </div>
          <div class="accordion accordion-flush" id="accordionFlushExample">
            <div class="accordion-item">
              <h2 class="accordion-header">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapseOne" aria-expanded="false" aria-controls="flush-collapseOne">
                  Why use toughened glass partitions? 
                </button>
              </h2>
              <div id="flush-collapseOne" class="accordion-collapse collapse" data-bs-parent="#accordionFlushExample">
                <div class="accordion-body">
                  <p>One of the many benefits of glass is that it can provide a slim yet strong barrier for various purposes, while remaining clear or translucent for easy sightlines and improved light flow.</p>
                  <p>Glass partitions have a relatively small footprint, so they can fit seamlessly into all kinds of spaces, providing a ‘barely there’ appearance, as light can spread through them.</p>
                  <p>This helps to maintain a bright and airy atmosphere that encourages collaboration, but glass dividers also offer the opportunity for a level of peaceful privacy when needed – creating an appealing space for working, studying, or general living.</p>
                </div>
              </div>
            </div>
            <div class="accordion-item">
              <h2 class="accordion-header">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapseTwo" aria-expanded="false" aria-controls="flush-collapseTwo">
                  How thick should glass partitions be? 
                </button>
              </h2>
              <div id="flush-collapseTwo" class="accordion-collapse collapse" data-bs-parent="#accordionFlushExample">
                <div class="accordion-body">
                  <p>The minimum thickness for a glass partition available from Express Toughening is 8mm, which is the thinnest that a sheet of toughened glass can be for safe use as a partition.</p>
                  <p>The most common thickness is probably 10mm, with the majority of our glazing channels for partitions able to fit glass panels up to 12mm thick. Some are also available for partitions up to 15mm thick, but it’s important to double-check the dimensions before ordering to make sure the panel will fit securely in the channel.</p>
                </div>
              </div>
            </div>
            <div class="accordion-item">
              <h2 class="accordion-header">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapseThree" aria-expanded="false" aria-controls="flush-collapseThree">
                  What size can a glass partition be? 
                </button>
              </h2>
              <div id="flush-collapseThree" class="accordion-collapse collapse" data-bs-parent="#accordionFlushExample">
                <div class="accordion-body">
                  <p>The size of a glass partition also depends on variables such as where it will be used, the installation method, and the thickness of the glass, as well as the shape of the partition.</p>
                  <p>We don’t just offer standard rectangular or square glass partitions, but also left, right, or double rake shapes, or cut-off corners for more graded edges. This makes it easier to design a glass partition that fits exactly where you want it, while being durable enough to withstand wear and tear.</p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="sp_additions_sec pb-5">
        <div class="container">
          <div class="faqs-introduction sdtnl_nds pt-4 mb-4">
            <h2 class="main-heading">Additions you may need</h2>			
            <div class="article-content">Explore the range of fittings you may need for your product.</div>
          </div>
          <div class="row">
            <div class="col-md-6 col-lg-3">
              <div class="shop_product_items">
                <a href="#">
                  <div class="shop_product_images">
                    <div class="inside_shop_product_images">
                      <img src="<?php echo get_template_directory_uri(); ?>/assets/img/product/product-05.webp" alt="" class="img-fluid">
                    </div>
                  </div>
                  <h4 class="shop_product_title">Glass Shelves</h4>
                  <!--<p class="sp_price">£57.60 – £210.00</p>-->
                </a>
                <div class="shop_product_button">
                  <a href="#" class="btn btn-info">Buy Now</a>
                </div>
              </div>
            </div>
            <div class="col-md-6 col-lg-3">
              <div class="shop_product_items">
                <a href="#">
                  <div class="shop_product_images">
                    <div class="inside_shop_product_images">
                      <img src="<?php echo get_template_directory_uri(); ?>/assets/img/product/product-03.webp" alt="" class="img-fluid">
                    </div>
                  </div>
                  <h4 class="shop_product_title">Glass Shelves</h4>
                  <!--<p class="sp_price">£57.60 – £210.00</p>-->
                </a>
                <div class="shop_product_button">
                  <a href="#" class="btn btn-info">Buy Now</a>
                </div>
              </div>
            </div>
            <div class="col-md-6 col-lg-3">
              <div class="shop_product_items">
                <a href="#">
                  <div class="shop_product_images">
                    <div class="inside_shop_product_images">
                      <img src="<?php echo get_template_directory_uri(); ?>/assets/img/product/product-02.webp" alt="" class="img-fluid">
                    </div>
                  </div>
                  <h4 class="shop_product_title">Glass Shelves</h4>
                  <!--<p class="sp_price">£57.60 – £210.00</p>-->
                </a>
                <div class="shop_product_button">
                  <a href="#" class="btn btn-info">Buy Now</a>
                </div>
              </div>
            </div>
            <div class="col-md-6 col-lg-3">
              <div class="shop_product_items">
                <a href="#">
                  <div class="shop_product_images">
                    <div class="inside_shop_product_images">
                      <img src="<?php echo get_template_directory_uri(); ?>/assets/img/product/product-01.webp" alt="" class="img-fluid">
                    </div>
                  </div>
                  <h4 class="shop_product_title">Glass Shelves</h4>
                  <!--<p class="sp_price">£57.60 – £210.00</p>-->
                </a>
                <div class="shop_product_button">
                  <a href="#" class="btn btn-info">Buy Now</a>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </main><!-- End #main -->

<?php get_footer(); 