<?php /*Template Name: Shop Page*/
get_header(); ?>

<section class="innerBanner shopBanner py-0">
    <img src="<?php echo get_template_directory_uri(); ?>/assets/img/shop-banner.webp" alt="" class="img-fluid">
    <div class="innerBnr__caption">
      <div class="container">
        <div class="inner__Title">Products</div>
        <div class="breadcrumbs">
          <ol>
            <li><a href="<?php echo home_url(); ?>">Home</a></li>
            <li>Products</li>
          </ol>
        </div>
      </div>
    </div>
  </section>
  <main id="main">
    <section class="shop_pg_sec">
        <div class="container">
            <div class="defltHdr shopDfltHdr text-center">
              <h2 class="mb-4">Product Results</h2>
              <p>Express Toughening is the premier toughened glass manufacturer in the South East of England. Established in January 2001 we are a rapidly growing enterprise based within touching distance of the M25. With state of the art equipment and a service that is unmatched within the industry, we offer a wide variety of glass products including 4mm to 19mm Clear, Low Iron, Low-E, Patterned, Laminated, Painted and much more to meet your ever-increasing needs.</p>
            </div>
            <!--<div class="shopTopFltr">
                <div class="row">
                    <?php echo do_shortcode('[products]'); ?>
                </div> 
            </div>-->
            <div class="cd-main-content shop_products">
                <div class="cd-tab-filter-wrapper">
                    
                </div> <!-- cd-tab-filter-wrapper -->
                <section class="cd-gallery">
                    <ul>
                        <?php 
                            $args = array(
                                'post_type'      => 'product',
                                'posts_per_page' => -1, // Get all products
                                'orderby'        => 'ID',
                                'order'          => 'ASC'
                            );
                            
                            $products = new WP_Query($args);
                            
                            if ($products->have_posts()) :
                                while ($products->have_posts()) : $products->the_post();
                                    $product_id   = get_the_ID();
                                    $product      = wc_get_product($product_id);
                                    $title        = get_the_title();
                                    $link         = get_permalink();
                                    $image        = get_the_post_thumbnail_url($product_id, 'full');
                                    
                                    // Get product categories
                                    $categories = wp_get_post_terms($product_id, 'product_cat', array('fields' => 'slugs'));
                                    $category_names = implode(', ', $categories);
                                    
                                    echo '<li class="mix ' . esc_html($category_names) . '">
                                            <div class="shop_product_items">
                                              <a href="' . esc_url($link) . '">
                                                <div class="shop_product_images">
                                                  <div class="inside_shop_product_images">
                                                    <img src="' . esc_url($image) . '" alt="' . esc_attr($title) . '" class="img-fluid" style="height:217px;">
                                                  </div>
                                                </div>
                                                <h4 class="shop_product_title">' . esc_html($title) . '</h4>
                                              </a>
                                              <div class="shop_product_button">
                                                <a href="' . esc_url($link) . '" class="btn btn-info">Buy Now</a>
                                              </div>
                                            </div>
                                          </li>';
                            
                                    // Output the data
                                    /*echo '<div>';
                                    echo '<a href="' . esc_url($link) . '">';
                                    echo '<img src="' . esc_url($image) . '" alt="' . esc_attr($title) . '">';
                                    echo '<h2>' . esc_html($title) . '</h2>';
                                    echo '</a>';
                                    echo '<p>Category: ' . esc_html($category_names) . '</p>';
                                    echo '</div>';*/
                            
                                endwhile;
                                wp_reset_postdata();
                            endif;

                        ?>
                    </ul>
                </section>
                <div class="cd-filter">
                    <form>
                        <div class="cd-filter-block">
                            <h4>Shop By</h4>
                            <?php 
                            $categories = get_terms(array(
                                'taxonomy'   => 'product_cat',
                                'hide_empty' => true, // Set to true to exclude empty categories
                            ));
                            
                            if (!empty($categories) && !is_wp_error($categories)) { $cnt=1; ?>
                            <ul class="cd-filter-content cd-filters list">
                                <?php foreach ($categories as $category) { ?>
                                    <li>
                                        <input class="filter" data-filter=".<?php echo esc_html($category->slug); ?>" type="checkbox" id="checkbox<?php echo $cnt; ?>">
                                        <label class="checkbox-label" for="checkbox<?php echo $cnt; ?>"><?php echo esc_html($category->name); ?></label>
                                    </li>
                                <?php $cnt++; } ?>
                            </ul>
                            <?php } ?>
                        </div>
                    </form>
                </div>
            </div>    
        </div>
    </section>
  </main><!-- End #main -->


<?php get_footer();